﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using hive;

//	Summary
// 		* 홈 scene의 캠페인

 namespace GameCampaign
{
	/*
		캠페인 item.  
	*/
	public class CampaignItem : MonoBehaviour
	{
		public delegate void onCampaignItemEvent (CampaignItem item);

		public event onCampaignItemEvent onCampaignItem;

		private AppInvitationCampaign _campaign;

		public AppInvitationCampaign campaign {
			get {
				return _campaign;
			}
		}

		public Text TitleText;
		public Text DetailText;
		public Text GoldText;

		public GameObject ActiveButton;
		public GameObject InActiveButton;

		private bool _active	= true;

		public bool active {
			set {
				_active = value;
				setButtonActive (_active);
			}

			get {
				return _active;
			}
		}

		/*
			캠페인 item setter.

			@param campaign HIVE promotion을 캠페인.
			@param isStageCampaign stage 캠페인 여부. 만약 true이면, 진행 여부를 text로 노출한다.(ex. 1 / 10).
		 */
		public void setCampaign (AppInvitationCampaign campaign, bool isStageCampaign)
		{
			_campaign			= campaign;

			TitleText.text = campaign.title;

			if (isStageCampaign == true) {
				AppInvitationCampaignStage stageCampaign = campaign as AppInvitationCampaignStage;
				DetailText.text = campaign.description + " (" + stageCampaign.goalCount + " / " + stageCampaign.goalTotal + ")";
			} 
			else {
				DetailText.text = campaign.description + " (" + campaign.count + " / " + campaign.limit + ")";
			}

			if (campaign.item != null) {
				int goldInt = 0;
				campaign.item.GetField (ref goldInt, "gold");

				GoldText.text = goldInt.ToString ();
			}

		}

		/*
			캠페인 item의 선택시 event method.
		 */
		public void onClick ()
		{
			if (onCampaignItem != null) {
				onCampaignItem (this);
			}
		}

		/*
			캠페인 item의 활성 여부. (완료 여부)
		 */
		void setButtonActive (bool active)
		{
			if (active == true) {
				ActiveButton.SetActive (true);
				InActiveButton.SetActive (false);
			} else {
				ActiveButton.SetActive (false);
				InActiveButton.SetActive (true);
			}
		}
	}
}
